package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(value = {"all"})
public class InstructorContainer implements Serializable {
    private List<Instructor> instructors;

    public InstructorContainer() {
        instructors = new ArrayList<Instructor>();
    }

    public List<Instructor> getInstructors() {
        return instructors;
    }

    public void setInstructors(List<Instructor> instructors) {
        this.instructors = instructors;
    }

    private Instructor search(String initials) {
        Instructor instructor;
        Iterator<Instructor> it = this.instructors.iterator();
        while (it.hasNext()) {
            instructor = it.next();
            if (instructor.isEqualTo(initials)) {
                return instructor;
            }
        }
        return null;
    }

    public List<Instructor> getAll() {
        List<Instructor> newlist = new ArrayList();
        newlist.addAll(this.instructors);
        return newlist;
    }

    public Instructor get(String initials) {
        Instructor instructor = search(initials);
        return instructor;
    }

    public void add(Instructor obj) {
        Instructor instructor = search(obj.getInitials());
        if (instructor == null) {
            this.instructors.add(obj);
        } else {
            String msg = "Instructor: " + obj.getInitials() + " already exists";
            throw new DuplicatedDataException(msg);
        }
    }

    public void remove(String initials) {
        Instructor instructor = search(initials);
        if (instructor != null) {
            this.instructors.remove(instructor);
        }
    }

    public void update(String initials, String name) {
        Instructor instructor = search(initials);
        if (instructor != null) {
            instructor.setName(name);
        }
    }
}